; sse_string_search.asm
extern printf
section .data
;szablon	 123456789012345678901234567890123456789012345  6 
;szablon	 0123456789abcdef0123456789abcdef0123456789abc  d  
string1	db	"the quick brown fox jumps over the lazy river",0 

string2	db	"e",0     
fmt1 	db 	"To jest nasz łańcuch: %s ",10,0                 
fmt2 	db 	"Pierwszy znak '%s' jest na pozycji %d.",10,0
fmt3 	db 	"Ostatni znak '%s' jest na pozycji %d.",10,0
fmt4 	db 	"Znak '%s' nie został znaleziony!",10,0

section .bss
section .text							
	global main					 
main:
push	rbp
mov	rbp,rsp
	mov 	rdi, fmt1
    	mov 	rsi, string1
    	xor 	rax,rax
    	call printf 

; znajdujemy pierwsze wystąpienie
    	mov 	rdi, string1
   	mov  rsi, string2
    	call pstrscan_f
	cmp	rax,0
	je	no_show
    	mov 	rdi, fmt2
	mov	rsi, string2
    	mov 	rdx, rax
    	xor 	rax,rax
    	call	printf 

; znajdujemy ostatnie wystąpienie
    	mov 	rdi, string1
  	mov  rsi, string2
    	call pstrscan_l
    	mov 	rdi, fmt3
	mov	rsi, string2
    	mov 	rdx, rax
    	xor 	rax,rax
    	call printf
	jmp	exit
no_show:
	mov	rdi, fmt4
	mov	rsi, string2
	xor	rax, rax
	call	printf     
exit:
leave
ret
;------ znajdujemy pierwsze wystąpienie -------------
pstrscan_f:
push	rbp		
mov	rbp,rsp
	xor		rax, rax		
	pxor  	xmm0, xmm0		
	pinsrb	xmm0, [rsi],0
.block_loop:	
	pcmpistri  xmm0, [rdi + rax], 00000000b    
	jc	.found
	jz	.none
	add	rax, 16
	jmp	.block_loop
.found:		                   
	add 	rax, rcx		; rcx zawiera pozycję znaku
	inc	rax			; zaczynamy liczyć od 1, a nie od 0
leave
ret
.none:
	xor	rax,rax			; nic nie znaleziono, zwracamy 0
leave
ret

;------ znajdujemy ostatnie wystąpienie --------------	
pstrscan_l:
push	rbp		
mov	rbp,rsp
push rbx			; zapisywany przez wywołanego
push r12			; zapisywany przez wywołanego
	xor		rax, rax
	pxor  	xmm0, xmm0		
	pinsrb	xmm0, [rsi],0
	xor		r12,r12
.block_loop:	
	pcmpistri  xmm0, [rdi + rax], 01000000b    
	setz	bl
	jc	.found
	jz   .done
	add	rax, 16
   	jmp .block_loop
.found:	
	mov	r12, rax	                   
	add  r12, rcx		; rcx zawiera pozycję znaku
	inc	r12
	cmp	bl,1
	je	.done
    	add  rax,16
	jmp	.block_loop
pop r12			; zapisywany przez wywołanego
pop rbx			; zapisywany przez wywołanego
leave
ret
.done:
	mov	rax,r12	
pop r12			; zapisywany przez wywołanego
pop rbx			; zapisywany przez wywołanego
leave
ret

